'use strict';

/* --------------------------------------------------------------
 modal.js 2019-03-27
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Component that opens a modal layer with the URL given by
 * an a-tag that has the class "js-open-modal". For backwards
 * compatibility the class "lightbox_iframe" is possible, also.
 */
gambio.widgets.module('modal', [gambio.source + '/libs/modal.ext-magnific', gambio.source + '/libs/modal'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        defaults = {
        add: '&lightbox_mode=1' // Add this parameter to each URL
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    // ########## EVENT HANDLER ##########

    /**
     * Event handler to open the modal
     * window with the link data
     * @param       {object}    e       jQuery event object
     * @private
     */
    var _openModal = function _openModal(e) {
        e.preventDefault();

        var $self = $(this),
            url = $self.attr('href'),
            dataset = $self.parseModuleData('modal'),
            type = dataset.type || e.data.type,
            settings = $.extend({}, dataset.settings || {});

        url += url[0] === '#' || url[0] === '.' ? '' : options.add;
        settings.template = url;
        if (settings.refreshOnClose) {
            settings.callbacks = {
                "close": function close() {
                    location.reload();
                }
            };
        }

        jse.libs.theme.modal[type](settings);
        if (dataset.finishEvent) {
            $('body').trigger(dataset.finishEvent);
        }
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {

        $this.on('click', '.js-open-modal', _openModal).on('click', '.lightbox_iframe', { type: 'iframe' }, _openModal);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
